qui {
noisily {
	/*************************************************/
	/*** Step 1.14. Data construction: Details	  ****/
	/*************************************************/
	}

/* 1.14.1. Detail data sources for each country-year */

	* Route to tex-output
	cd ..
	cd ".\5. TeX results"
	
	* Declare panel structure
	xtset cntrycode year
	
	* Correctly identify non-reported country-years for battle deaths and financial crisis variables
	preserve
	replace bdeaths = . 		if source_bdeaths == .
	replace source_bdeaths  = . if bdeaths == .
	replace bdeaths = . 		if source_bdeaths == 2 & year < 1960	// WDI data coverage only starts in 1960, assume missing country-years reflect 0's
	replace source_bdeaths = . 	if source_bdeaths == 2 & year < 1960	
	replace bdeaths = . 		if source_bdeaths == 1 & year > 2003 	// PRIO data coverage ends in 2003, assume missing country-years reflect 0's
	replace source_bdeaths = . 	if source_bdeaths == 1 & year > 2003 	
	replace crisis = . 			if source_crisis == . 
	replace source_crisis  = . 	if crisis == . 
	replace crisis = . 			if source_crisis == 1 & year > 2010		// RR data coverage ends in 2010, assume missing country-years reflect 0's
	replace source_crisis = . 	if source_crisis == 1 & year > 2010
	
	* Correct Serbia country name
	replace cntry = "Serbia" if cntry == "ZzSerbia"
		
	* Generate gdpcap variable
	generate gdpcap = baseline_gdpcap
	
	* Generate necessary columns
	gen str variable_name = ""
	gen str preindependence_obs = ""
	gen str postindependence_obs = ""
	gen str sources = ""
	gen str interpolated = ""
	gen str extrapolated = ""
	gen str polynomialpredicted = ""
		
	* Report data sources for all variables of interest
	local counter = 0

	foreach variable in surface pop gdpcap educ health open dem bdeaths crisis {
			
		* Identify row in which to report data provenance for this variable
		local counter = `counter'+3
		sum year
		local current_row = `r(min)'+`counter'-3
		local current_row2 = `r(min)'+`counter'-2
		local current_row3 = `r(min)'+`counter'-1
	
		* Identify variable
		replace variable_name = "Surface area" if "`variable'" == "surface" & year == `current_row' | "`variable'" == "surface" & year == `current_row2' | "`variable'" == "surface" & year == `current_row3'
		replace variable_name = "Population" if "`variable'" == "pop" & year == `current_row' | "`variable'" == "pop" & year == `current_row2' | "`variable'" == "pop" & year == `current_row3'
		replace variable_name = "Per capita GDP" if "`variable'" == "gdpcap" & year == `current_row' | "`variable'" == "gdpcap" & year == `current_row2' | "`variable'" == "gdpcap" & year == `current_row3'
		replace variable_name = "Education" if "`variable'" == "educ" & year == `current_row' | "`variable'" == "educ" & year == `current_row2' | "`variable'" == "educ" & year == `current_row3'
		replace variable_name = "Life expectancy" if "`variable'" == "health" & year == `current_row' | "`variable'" == "health" & year == `current_row2' | "`variable'" == "health" & year == `current_row3'
		replace variable_name = "Trade openness" if "`variable'" == "open" & year == `current_row' | "`variable'" == "open" & year == `current_row2' | "`variable'" == "open" & year == `current_row3'
		replace variable_name = "Democracy" if "`variable'" == "dem" & year == `current_row' | "`variable'" == "dem" & year == `current_row2' | "`variable'" == "dem" & year == `current_row3'
		replace variable_name = "Battle deaths" if "`variable'" == "bdeaths" & year == `current_row' | "`variable'" == "bdeaths" & year == `current_row2' | "`variable'" == "bdeaths" & year == `current_row3'
		replace variable_name = "Financial crises" if "`variable'" == "crisis" & year == `current_row' | "`variable'" == "crisis" & year == `current_row2' | "`variable'" == "crisis" & year == `current_row3'
		
		* Correctly identify sources
		forval i=1/9 {
			replace source_`variable' = `i' if source_`variable' == 99`i'
			replace source_`variable' = `i' if source_`variable' == 90`i'
			}
			

		* Identify sources
		
			* Surface area
			if "`variable'" == "surface" {
				local source1 = "{Lake2004}"
				local source2 = "{WorldBank2015}"
				}
				
			* Population
			if "`variable'" == "pop" {
				local source1 = "{CorrelatesofWarProject2012}"
				local source2 = "{TheMadisonProject2018}"
				local source3 = "{WorldBank2015}"
				local source4 = "{Madison2010}"
				local source5 = "{Feenstra2015}"
				local source6 = "{CLIOInfra2015}"
				local source7 = "{Heston1994}"
				}
				
			* Per capita GDP (baseline)
			if "`variable'" == "gdpcap" {
				local source1 = "{TheMadisonProject2013}"
				local source2 = "{WorldBank2015}"
				local source3 = "{WorldResourcesInstitute2015}$^{*}$"
				local source4 = "{WorldBank2015}$^{*}$"
				local source5 = "{CorrelatesofWarProject2012}$^{*}$"
				}
				
			* Education
			if "`variable'" == "educ" {
				local source1 = "{CLIOInfra2015}"
				local source2 = "{UnitedNationsDevelopmentProgram2015}"
				local source3 = "{Barro2012}$^{*}$"
				local source4 = "{Barro1994}$^{*}$"
				local source5 = "{WorldBank2015}$^{*}$"
				local source6 = "{Barro1994}$^{*}$"
				}
				
			* Life expectancy
			if "`variable'" == "health" {
				local source1 = "{WorldBank2015}"
				local source2 = "{CLIOInfra2015}"
				local source3 = "{Barro1994}"
				
				local source12 = "{WorldBank2015,CLIOInfra2015}"
				local source13 = "{WorldBank2015,Barro1994}"
				local source23 = "{CLIOInfra2015,Barro1994}"
				
				local source123 = "{WorldBank2015,CLIOInfra2015,Barro1994}"
				}	
				
			* Trade openness
			if "`variable'" == "open" {
				local source1 = "{Feenstra2015}"
				local source2 = "{WorldBank2015}"
				local source3 = "{Heston1994}$^{*}$"
				local source4 = "{CorrelatesofWarProject2015}"
				}
				
			* Democracy
			if "`variable'" == "dem" {
				local source1 = "{CLIOInfra2015}"
				local source2 = "{Vanhanen2014}"
				local source3 = "{Gibler2014a}$^{*}$"
				local source4 = "{Pemstein2010}$^{*}$"
				local source5 = "{Giuliano2013}$^{*}$"
				local source6 = "{FreedomHouse2015}$^{*}$"
				local source7 = "{CenterforSystemicPeace2014}$^{*}$"
				}

			* Battle-related deaths
			if "`variable'" == "bdeaths" {
				local source1 = "{Bethany2005}"
				local source2 = "{WorldBank2015}"
				local source12 = "{Bethany2005,WorldBank2015}"
				}
			* Financial crises
			if "`variable'" == "crisis" {
				local source1 = "{Reinhart2011}"
				}
			
		* Collect country-year-specific information on data sources
		
			* Loop over all countries
			noi di ""
			noi di "`variable':"
			levelsof cntrycode if `variable' != . //& cntrycode <= 30
			foreach cntry in `r(levels)' {
			
				noi di `cntry', _continue
												
				* Identify state entry & exit years
				sum year if cntrycode == `cntry' & year >= $startyear & independence_years == 0
				if `r(N)' == 0 {
					local independence_year = $startyear
					}
				else if `r(N)' > 0 {
					local independence_year = r(mean)
					local independence_year_min = r(mean)-1
					}
				sum year if cntrycode == `cntry' & year >= $startyear & independence_years == .
				if `r(N)' == 0 {
					local exit_year = 2016
					}
				else if `r(N)' > 0 {
					local exit_year = `r(min)'-1
					}
					
				* Identify available observations pre & post-independence for this variable
				
					* Pre-independence
					sum year if cntrycode == `cntry' & year >= $startyear & year < `independence_year' & `variable' != .
					cap replace preindependence_obs = "`r(min)'-`r(max)'" if cntrycode == `cntry' & year == `current_row3'
					
					* Post-independence
					sum year if cntrycode == `cntry' & year >= $startyear & year >= `independence_year' & year <= `exit_year' & `variable' != .
					cap replace postindependence_obs = "`r(min)'-`r(max)'" if cntrycode == `cntry' & year == `current_row3'

				* Identify sources
				levelsof source_`variable' if source_`variable' < 200
				local helpme = 0
				foreach Source in `r(levels)' {
				
					* Remove information from prior loop
					local count = 1
					local previous = .
					forval i=1/25 {
						local min`i' = .
						local max`i' = .
						}
						
					* Check time coverage of this source
					levelsof year if cntrycode == `cntry' & year >= $startyear & year <= `exit_year' & source_`variable' == `Source' | cntrycode == `cntry' & year >= $startyear & year <= `exit_year' & source_`variable' == `=990+`Source''
					foreach year in `r(levels)' {
						
						* Track continuous data coverage for this source
						if `min`count'' == . {
							local min`count' = `year'
							}
							
						if `previous' != . {
							if `year'-`previous' == 1 {
								local max`count' = `year'
								}
							else if `year'-`previous' > 1 {
								local count = `count' + 1
								local min`count' = `year'
								}
							}

						local previous = `year'		
						}
					
						* Track in which row to report information, to increase legibility
						if `min`count'' != . {
							local helpme = `helpme'+1
							}
							
						if `Source' > 100 {
							local helpme = `helpme'+1
							}
							
						if `helpme' <= 2 {
							local row = `current_row'
							}
						else if `helpme' > 2 &  `helpme' <= 4 {
							local row = `current_row2'
							}				
						
						else if `helpme' > 4 {
							local row = `current_row3'
							}				
						
						* Report information
						foreach block of numlist 1/`count' {
						
							replace sources = sources+"\citeA`source`Source'': `min`block''-`max`block''" if cntrycode == `cntry' & year == `row' & sources == "" & `max`block'' != . & `Source' != 0
							replace sources = sources+"\citeA`source`Source'': `min`block''" if cntrycode == `cntry' & year == `row' & sources == "" & `max`block'' == . & `min`block'' != . & `Source' != 0
							
							replace sources = sources+" ; \citeA`source`Source'': `min`block''-`max`block''" if cntrycode == `cntry' & year == `row' & `Source' != 1 & `block' == 1  & `Source' != 0 & sources != "" & `max`block'' != . & sources != "\citeA`source`Source'': `min`block''-`max`block''"
							replace sources = sources+" ; \citeA`source`Source'': `min`block''" if cntrycode == `cntry' & year == `row' & `Source' != 1  & `block' == 1  & `Source' != 0 & `max`block'' == . & sources != "" & `min`block'' != . & sources != "\citeA`source`Source'': `min`block''"
						
							replace sources = sources+"; `min`block''-`max`block''" if cntrycode == `cntry' & year == `row' & `max`block'' != .  & `block' > 1 & `Source' != 0
							replace sources = sources+"; `min`block''" if cntrycode == `cntry' & year == `row' & `max`block'' == . & `min`block'' != .    & `block' > 1 & `Source' != 0
							}
						}

				* Identify linearly interpolated data points, extrapolated and polynomial predicted data series
				
					* Linearly interpolated data series
					
						* Remove information from prior loop
						local count = 1
						local previous = .
						forval i=1/25 {
							local min`i' = .
							local max`i' = .
							}
						local helpme = 0
						
						* Check time coverage of interpolated data points
						levelsof year if cntrycode == `cntry' & year >= $startyear & year <= `exit_year' & interpolated_`variable' == 1
						foreach year in `r(levels)' {
							
							* Track continuous interpolated time series
							if `min`count'' == . {
								local min`count' = `year'
								}
								
							if `previous' != . {
								if `year'-`previous' == 1 {
									local max`count' = `year'
									}
								else if `year'-`previous' > 1 {
									local count = `count' + 1
									local min`count' = `year'
									}
								}

							local previous = `year'
							
							}
					
						* Report information
						foreach block of numlist 1/`count' {
						
							* Track in which row to report information, to increase legibility
							if `min`block'' != . {
								local helpme = `helpme'+1
								}
								
							if `helpme' <= 2 {
								local row = `current_row'
								}
							else if `helpme' > 2 &  `helpme' <= 4 {
								local row = `current_row2'
								}				
							
							else if `helpme' > 4 {
								local row = `current_row3'
								}
						
							replace interpolated = interpolated+"; `min`block''-`max`block''" if cntrycode == `cntry' & year == `row' & interpolated != "" & `min`block'' != .
							replace interpolated = interpolated+"`min`block''-`max`block''" if cntrycode == `cntry' & year == `row' & interpolated == "" & `min`block'' != .
							}
					
					
					* Extrapolated parts
					
						* Remove information from prior loop
						local count = 1
						local previous = .
						forval i=1/25 {
							local min`i' = .
							local max`i' = .
							}
							
						* Check time coverage of extrapolated data points
						levelsof year if cntrycode == `cntry' & year >= $startyear & year <= `exit_year' & extrapolated_`variable' == 1
						foreach year in `r(levels)' {
						
							* Track continuous extrapolated time series
							if `min`count'' == . {
								local min`count' = `year'
								}

							if `previous' != . {
								if `year'-`previous' == 1 {
									local max`count' = `year'
									}
								else if `year'-`previous' > 1 {
									local count = `count' + 1
									local min`count' = `year'
									}
								}

							local previous = `year'
							}
							
						* Report information
						foreach block of numlist 1/`count' {
							replace extrapolated = extrapolated+"; `min`block''-`max`block''" if cntrycode == `cntry' & year == `current_row' & extrapolated != "" & `min`block'' != .
							replace extrapolated = extrapolated+"`min`block''-`max`block''" if cntrycode == `cntry' & year == `current_row' & extrapolated == "" & `min`block'' != .
							}
					
					* Polynomial predicted parts
					
						* Remove information from prior loop
						local count = 1
						local previous = .
						forval i=1/25 {
							local min`i' = .
							local max`i' = .
							}
							
						* Check time coverage of polynomial predicted data points
						levelsof year if cntrycode == `cntry' & year >= $startyear & year <= `exit_year' & polynomialpredicted_`variable' == 1
						foreach year in `r(levels)' {
						
							* Track continuous polynomial predicted time series
							if `min`count'' == . {
								local min`count' = `year'
								}
								
							if `previous' != . {
								if `year'-`previous' == 1 {
									local max`count' = `year'
									}
								else if `year'-`previous' > 1 {
									local count = `count' + 1
									}
								}

							local previous = `year'
							}
							
						* Report information
						foreach block of numlist 1/`count' {
							replace polynomialpredicted = polynomialpredicted+"; `min`block''-`max`block''" if cntrycode == `cntry' & year == `current_row' & polynomialpredicted != "" & `min`block'' != . & `max`block'' != .
							replace polynomialpredicted = polynomialpredicted+"`min`block''-`max`block''" if cntrycode == `cntry' & year == `current_row' & polynomialpredicted == "" & `min`block'' != . & `max`block'' != .
							replace polynomialpredicted = polynomialpredicted+"; `min`block''" if cntrycode == `cntry' & year == `current_row' & polynomialpredicted != "" & `min`block'' != . & `max`block'' == .
							replace polynomialpredicted = polynomialpredicted+"`min`block''" if cntrycode == `cntry' & year == `current_row' & polynomialpredicted == "" & `min`block'' != . & `max`block'' == .
							}				
						}
					}
			
	* Prepare data for export
	
		* Keep necessary variables
		keep year cntry variable_name preindependence_obs postindependence_obs sources interpolated extrapolated polynomialpredicted independence_years
		
		* Only keep countries that were independent anywhere between 1940-2016 with data
		gen independence_years2 = independence_years if year >= $startyear
		replace independence_years2 = -9999 if independence_years2 == .
		bysort cntry: egen independence_dummy = max(independence_years2)
		drop if independence_dummy < 0
		drop independence_years independence_years2 independence_dummy
		
		* Keep necessary information
		drop if variable_name == ""
		
		* Replace ampersants with a format that Latex can handle
		replace cntry = subinstr(cntry,"&","\&",.)
		
		* Organize information for export to .tex table
		
			* Put variable names in multirow & add color scheme to increase legibility
			sort cntry year
			gen odd = !mod(_n,2)
			replace variable_name = "" if variable_name[_n]==variable_name[_n+1]
			replace variable_name = "" if variable_name[_n]==variable_name[_n+2]
			replace variable_name = "\multirow{-3}{*}{"+variable_name+"}" if variable_name != "" & odd == 1
			replace variable_name = "\multirow{-3}{*}{\cellcolor[gray]{.9}"+variable_name+"}" if variable_name != "" & odd == 0
			
			* Fill missings
			foreach variable in preindependence_obs postindependence_obs {
				replace `variable' = "-" if `variable' == "" & variable_name != ""
				}
				
			* Put information on pre- and post-independece data coverage in multirow & add color scheme to increase legibility
			sort cntry year
			replace preindependence_obs = "\multirow{-3}{*}{"+preindependence_obs+"}" if preindependence_obs != "" & odd == 1
			replace postindependence_obs = "\multirow{-3}{*}{"+postindependence_obs+"}" if postindependence_obs != "" & odd == 1
			replace preindependence_obs = "\multirow{-3}{*}{\cellcolor[gray]{.9}"+preindependence_obs+"}" if preindependence_obs != "" & odd == 0
			replace postindependence_obs = "\multirow{-3}{*}{\cellcolor[gray]{.9}"+postindependence_obs+"}" if postindependence_obs != "" & odd == 0

			* Put country names in multirow & add color scheme to increase legibility
			sort cntry year
			gen cname = "\multirow{-27}{*}{\cellcolor[gray]{.8}\rotatebox[origin=c]{90}{\makecell{\textbf{"+cntry+"}}}}" if variable_name == "\multirow{-3}{*}{\cellcolor[gray]{.9}Financial crises}"
			replace cname = "\multirow{-27}{*}{\cellcolor[gray]{.86}\rotatebox[origin=c]{90}{\makecell{\textbf{"+cntry+"}}}}" if variable_name == "\multirow{-3}{*}{Financial crises}"
			replace cname = "" if variable_name != "\multirow{-3}{*}{\cellcolor[gray]{.9}Financial crises}" & variable_name != "\multirow{-3}{*}{Financial crises}"
			
			* Color cells not colored yet (in multirow environments)
			sort cntry year
			replace variable_name = "\cellcolor[gray]{.9}"+variable_name if strpos(variable_name[_n+1], "[gray]") & variable_name == ""
			replace variable_name = "\cellcolor[gray]{.9}"+variable_name if strpos(variable_name[_n+2], "[gray]") & variable_name == ""
			replace preindependence_obs = "\cellcolor[gray]{.9}"+preindependence_obs if strpos(preindependence_obs[_n+1], "[gray]") & preindependence_obs == ""
			replace preindependence_obs = "\cellcolor[gray]{.9}"+preindependence_obs if strpos(preindependence_obs[_n+2], "[gray]") & preindependence_obs == ""
			replace postindependence_obs = "\cellcolor[gray]{.9}"+postindependence_obs if strpos(postindependence_obs[_n+1], "[gray]") & postindependence_obs == ""
			replace postindependence_obs = "\cellcolor[gray]{.9}"+postindependence_obs if strpos(postindependence_obs[_n+2], "[gray]") & postindependence_obs == ""
			forval i=1/26 {
				replace cname = "\cellcolor[gray]{.8}"+cname  if strpos(cname[_n+1], "[gray]{.8}") & cname == ""
				replace cname = "\cellcolor[gray]{.86}"+cname  if strpos(cname[_n+1], "[gray]{.86}") & cname == ""
				}
			foreach var in sources interpolated extrapolated polynomialpredicted {
				replace `var' = "\cellcolor[gray]{.9}"+`var' if strpos(preindependence_obs, "[gray]")
				}
				
		* Export table
		listtab cname variable_name preindependence_obs postindependence_obs sources interpolated extrapolated polynomialpredicted ///
		using tableA2.tex,  replace ///
		rstyle(tabular)
		restore
		
	* Reroute to directory containing dofiles		
	cd ..
	cd ".\1. Dofiles"
	}	
